
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1303.C - Message 1303 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1303 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1303.C_v  $
//   
//      Rev 1.16   08 Dec 1999 15:53:34   phungh
//   Modify to allow more options of invalidating
//   eeprom
//   
//      Rev 1.15   09 Nov 1998 10:48:06   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:53:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:46   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:00:52   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:16   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "zcons.h"
#include "ztypes.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1303 message from the ZMsgBuf.
//
void Dec1303(tMSGBUF *ZMsgBuf, tMSG1303 *Msg)
{  
   GetBit(&CommandWord.InvalidateRAM      , ZMsgBuf, 7, 0); // 1=invalidate RAM
   GetBit(&CommandWord.InvalidateEEPROM   , ZMsgBuf, 7, 1); // 1=invalidate EEPROM                                         
   GetBit(&CommandWord.InvalidateRTC      , ZMsgBuf, 7, 2); // 1=invalidate RTC                                         
//   GetBit(&CommandWord.InvalidateEEPROM_FREQSTD, ZMsgBuf, 7, 3); // 1=invalidate EEPROM except Freq Std data
   GetBit(&CommandWord.InvalidateRAM_vEEPROM, ZMsgBuf, 7, 4); // 1=invalidate RAM execpt vEEPROM
   GetBit(&CommandWord.EEPROMClearOnlyFS  , ZMsgBuf, 7, 5); // 1=Clear Only EEPROM Freq Std Segments
//PCM v5.7 Not active for now.
//PCM   GetBit(&CommandWord.EEPROMKeepFSCubic  , ZMsgBuf, 7, 6); // 1=Keep EEPROM Freq Std Cubic
//PCM   GetBit(&CommandWord.EEPROMKeepFSTable  , ZMsgBuf, 7, 7); // 1=Keep EEPROM Freq Std Table
//PCM   GetBit(&CommandWord.EEPROMKeepFSCal    , ZMsgBuf, 7, 8); // 1=Keep EEPROM Freq Std 
//PCM   GetBit(&CommandWord.EEPROMKeepAlmanac  , ZMsgBuf, 7, 9); // 1=Keep EEPROM Almanac
//PCM   GetBit(&CommandWord.EEPROMKeepDRNav    , ZMsgBuf, 7,10); // 1=Keep EEPROM DR Nav
//PCM   GetBit(&CommandWord.ForceColdStart     , ZMsgBuf, 7,15); // 1=disable                                         
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1303 message in the ZMsgBuf. 
//
void Bld1303(tMSGBUF *ZMsgBuf, tMSG1303 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                       , ZMsgBuf, 1);    // message preamble  
   PutShort  (1303                         , ZMsgBuf, 2);    // message number  
   PutShort  (2                            , ZMsgBuf, 3);    // message length   
   PutShort  (ANREQ                        , ZMsgBuf, 4);    // message ack/nack request
 
   PutBit(CommandWord.InvalidateRAM    , ZMsgBuf, 7, 0); // 1=invalidate RAM
   PutBit(CommandWord.InvalidateEEPROM , ZMsgBuf, 7, 1); // 1=invalidate EEPROM            
   PutBit(CommandWord.InvalidateRTC    , ZMsgBuf, 7, 2); // 1=invalidate RTC            
   PutBit(0                            , ZMsgBuf, 7, 3); // Unused
   PutBit(CommandWord.InvalidateRAM_vEEPROM, ZMsgBuf, 7, 4); // 1=invalidate RAM except vEEPROM.
   PutBit(CommandWord.EEPROMClearOnlyFS, ZMsgBuf, 7, 5); // 1=Clear Only Freq Std Segments
//PCM v5.7 Not Active for now.
//PCM   PutBit(CommandWord.EEPROMKeepFSCubic, ZMsgBuf, 7, 6); // 1=Keep Freq Std Cubic
//PCM   PutBit(CommandWord.EEPROMKeepFSTable, ZMsgBuf, 7, 7); // 1=Keep Freq Std Table
//PCM   PutBit(CommandWord.EEPROMKeepFSCal  , ZMsgBuf, 7, 8); // 1=Keep Freq Std Calibration
//PCM   PutBit(CommandWord.EEPROMKeepAlmanac, ZMsgBuf, 7, 9); // 1=Keep Almanac
//PCM   PutBit(CommandWord.EEPROMKeepDRNav  , ZMsgBuf, 7,10); // 1=Keep DR Navigation
   PutBit(CommandWord.ForceColdStart   , ZMsgBuf, 7,15); // 1=disable                                         
}
